## WarmKey Integration Scripts

This project integrates with the **WarmKey** API to handle deposit address generation, withdrawals, and log-based synchronization via a cron job.

Main scripts:

- `deposit.php` – Generates deposit links/iframes and stores them in the database.
- `withdraw.php` – Creates withdrawal requests through WarmKey and logs them locally.
- `cronProcessLog.php` – Cron script that pulls WarmKey logs and synchronizes them into several local tables.

All scripts depend on:

- `config.php` – System, WarmKey, blockchain and cron configuration (e.g. `warmkey.api.url`, `warmkey.api_secret_key`, timezone).
- `common.php` – Returns a shared PDO connection via `Database::getInstance()->getConnection()`.

---

## 1. `deposit.php`

### Purpose

`DepositProcessor` generates multiple deposit links using the WarmKey API and stores each link in the `wk_address` table. The script then outputs a block of HTML iframes that can be embedded in your frontend to show payment widgets/QR codes.

### Input Parameters (via GET)

- `user_id` – user id (required).

## 2. `withdraw.php`

### Purpose

`WithdrawProcessor` exposes an HTTP endpoint that creates a WarmKey withdrawal request and logs it into `wk_withdrawal`. It returns a JSON response to the caller.

### Input Parameters (via GET)

- `to_address` – destination blockchain address (required).
- `amount` – amount to withdraw (required).
- `coin` – coin symbol, default: `BUSD`.
- `uniqueId` – withdrawal ID.
- `user_id` – user id (required).
- `network` – network (required).

---

## 3. `cronProcessLog.php`

### Purpose

`CronProcessor` is meant to be run periodically (e.g. via system cron or Windows Task Scheduler).  
It queries WarmKey logs and synchronizes them into local tables.

At the bottom of the script:

- It instantiates the class:  
  `\$cron = new CronProcessor();`
- It runs the job and echoes the result:  
  `echo $cron->processWarmKeyLogs();`


### WarmKey Log Query

`queryWarmKeyLogs()`:

1. Reads the last `log_id` from `wk_query_log` (default `1` if none).
2. Uses `log_id + 1` as the starting point for the next query.
3. Builds `payload = { log_id }` and `headers = { api_key, nonce }`.
4. Creates a signature using the **withdraw** private key:
   - SHA‑256 hash of JSON `{ header, payload }`, signed via OpenSSL.
5. Sends a JSON POST request to `"{warmkey.api.url}/paymentV1/queryLog"`.
6. Validates that `code == 100` in the WarmKey response.
7. Returns the `result` array (logs) or throws an exception if there is an error.

### Log Processing

`processLogs($logs)` iterates over each log and dispatches based on `log_type`:

- `deposit_link_created` → `processDepositLink($log)`
- `deposit_tx` → `processDepositTransaction($log)`
- `deposit_fundout` → `processFundOut($log)`
- `withdrawal_status_changed` → `processWithdrawalStatus($log)`

For each log, `logQuery($log)` writes an entry into `wk_query_log` so it will not be processed again.



## 4. Deployment Notes

- **PHP Extensions**
  - Ensure `openssl` and `curl` extensions are enabled.

- **Configuration**
  - Set the correct values in `config.php`:
    - `warmkey.api.url`, `warmkey.api.key`
    - `warmkey.api_secret_key`
    - `system.timezone`
    - `blockchain` settings for `bsc` (and other networks if you extend them).

- **Security**
  - Keep private keys out of version control.
  - Restrict access to `withdraw.php` and any other sensitive endpoints.


